package com.agilex.healthcare.mobilehealthplatform.domain;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(
        name = "mdwskey",
        namespace = "http://healthcare.agilex.com/mobilehealthplatform"
)
public class MdwsKey extends DomainTransferObject {
    private static final long serialVersionUID = -2587359966735035468L;
    @XmlAttribute (name = "@id")
    private String id;
    @XmlAttribute (name = "@name")
    private String name;

    public MdwsKey() {
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int hashCode() {
        boolean prime = true;
        byte result = 1;
        int result1 = 31 * result + (this.id == null?0:this.id.hashCode());
        result1 = 31 * result1 + (this.name == null?0:this.name.hashCode());
        return result1;
    }

    public boolean equals(Object obj) {
        if(this == obj) {
            return true;
        } else if(obj == null) {
            return false;
        } else if(this.getClass() != obj.getClass()) {
            return false;
        } else {
            MdwsKey other = (MdwsKey)obj;
            if(this.id == null) {
                if(other.id != null) {
                    return false;
                }
            } else if(!this.id.equals(other.id)) {
                return false;
            }

            if(this.name == null) {
                if(other.name != null) {
                    return false;
                }
            } else if(!this.name.equals(other.name)) {
                return false;
            }

            return true;
        }
    }

    public String toString() {
        return "MdwsKey [id=" + this.id + ", name=" + this.name + "]";
    }
}

